#import "PXColorWell.h"
#import "PXMatrix.h"

@implementation PXColorWell

- (void)mouseDown:event
{
	[super mouseDown:event];
	id enumerator = [[(PXMatrix *)[self superview] cells] objectEnumerator];
	id current;
	while(current = [enumerator nextObject])
	{
		if([current view] == self)
		{
			[(PXMatrix *)[self superview] selectCell:current];
		}
	}	
}

- (void)activate:(BOOL)exclusive
{
	if(NSPointInRect([[NSApp currentEvent] locationInWindow], [[self superview] convertRect:[self frame] toView:nil]))
	{
		[super activate:exclusive];
	}
}

- (void)deactivate
{
	[super deactivate];
	[self setNeedsDisplay:YES];
}

- (void)drawWellInside:(NSRect)insideRect
{
	[super drawWellInside:insideRect];
	if(isSelected) 
	{
		[[NSColor blackColor] set];
		NSRectFill(NSMakeRect(2, 23, 15, 7));
		[[NSColor redColor] set];
		NSRectFill(NSMakeRect(3, 24, 13, 5));		
	}
}

- (void)setSelected:(BOOL)selected
{
	isSelected = selected;
	if(selected)
	{
		[self activate:YES];
		[[NSNotificationCenter defaultCenter] postNotificationName:@"PXColorWellSelected" object:self userInfo:nil];
	}
	else
	{
		[self deactivate];
	}
	[self setNeedsDisplay:YES];
}

- copyWithZone:(NSZone *)zone
{
	return [[NSKeyedUnarchiver unarchiveObjectWithData:[NSKeyedArchiver archivedDataWithRootObject:self]] retain];
}

@end
